local super = require "TableColumn"

TextColumn = super:new()

local defaults = {
    halign = 0,
    valign = 0.5,
}

local nilDefaults = {
    'value', 'paint', 'font',
}

local getterNames = {'value', 'paint', 'font', 'halign', 'valign'}

local inspectorInfo = {
    {'KeyArtifact', {'value'}, 'Text'},
    {'Color', {'getPaint:setPaint', custom = 'hasExplicitPaint:'}, 'Color'},
    {'Font', {'getFont:setFont', custom = 'hasExplicitFont:'}, 'Font'},
    {'Alignment', {'halign'}, 'Alignment'},
}

function TextColumn:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self.stamp = TextStamp
    self.getterNames = getterNames
    self.inspectorInfo = inspectorInfo
    
    return self
end

function TextColumn:unarchived()
    local dataset = self:getDataset()
    if dataset then
        if self:getProperty('value') == nil then
            local avoidingFields = self:peerPropertyKeyArtifactValues(TextColumn, 'value')
            local field = dataset:pickField('string', avoidingFields)
            if field then
                self:setProperty('value', KeyArtifact:new(field))
                self:setTitle(field)
            end
        end
    end
    super.unarchived(self)
end

function TextColumn:getFont()
    return self:getProperty('font') or self:getParent():getLabelFont()
end

function TextColumn:setFont(value)
    self:setProperty('font', value)
end

function TextColumn:hasExplicitFont()
    return self:getProperty('font') ~= nil
end

return TextColumn
